/*
This code replicates Figure #4 and its appendix version: Canada and Mexico after the Taper Tantrum: May 2013
Data is from: IFS, Bloomberg, Consensus Forecast and Avdjiev, Stefan, Bryan Hardy, Sebnem Kalemli-Ozcan, and Luis Serven (2022).

Bloomberg and Consensus Forecast data is confidential, so we won't be providing the raw data.

*/

clear
set more off
cls 

//Adjust this this directory: 
cap cd "/Users/marianasans/Dropbox/Brookings paper/Do files/Final_Submission/Replication_pkg/Figure 4"

use "Data_fig4_TT.dta", clear

xtset IFS_code time_q

bysort IFS_code (time_q): gen Inflation_growth = (cpi_IFS - cpi_IFS[_n-1])/cpi_IFS[_n-1]
bysort IFS_code (time_q): gen Inflation_growth_percent = 100*(Inflation_growth - Inflation_growth[_n-4])

keep if time_q >= tq(2013q1) & time_q < tq(2015q1)

graph set window fontface "Times New Roman"


***Plot:

* Exchange rate growth
bysort IFS_code (time_q): gen ER_growth_percent = 100*(ER_avg - ER_avg[1])/ER_avg[1]

line ER_growth_percent time_q if(ISO_3_code == "CAN"), lc(blue) lwidth(thick)  ///
	|| (line ER_growth_percent time_q if(ISO_3_code == "MEX"), lc(red) lp(dash) lwidth(thick)) ,   ///
	xtitle("") xlab(, nogrid) xlabel(#7, angle(45))  /// 
	ytitle("% Change") ylab(-10(5)15, nogrid)  /// 
	ti("NER (Local Currency/USD)", size(medium)) legend(pos(6) label (1 "Canada") label (2 "Mexico") cols(1)) plotregion(style(none)) 
graph save Mex_Can_ER_Growth, replace

* 10 year tbill spread: we are not providing the raw data.
bysort IFS_code (time_q): gen tbill10yrChange = (tbill10yr_sprd_US - tbill10yr_sprd_US[1])

line tbill10yrChange time_q if(ISO_3_code == "CAN") , lc(blue)  lwidth(thick)  ///
	|| (line tbill10yrChange time_q if(ISO_3_code == "MEX"), lc(red) lp(dash) lwidth(thick)),  ///
	xtitle("") xlab(, nogrid)  xlabel(#7, angle(45))  ///
	ytitle("p.p") ylab(-.8(.2).6, nogrid)  ///
	ti("10 year govt. bond spreads", size(medium)) legend(pos(6) label (1 "Canada") label (2 "Mexico") cols(2)) plotregion(style(none))
graph save Mex_Can_10_yr_tbill_spread, replace

* UIP: we are not providing the raw data
bysort IFS_code (time_q): gen EUIP12m = 100*(ln_theta_12m_avg - ln_theta_12m_avg[1])


line EUIP12m time_q if(ISO_3_code == "CAN"), lc(blue) lwidth(thick)  ///
	|| (line EUIP12m time_q if(ISO_3_code == "MEX"), lc(red) lp(dash) lwidth(thick)) ,  ///
	xtitle("") xlab(, nogrid)  xlabel(#7, angle(45))  ///
	ytitle("% Change") ylab(-5(1)2, nogrid)  ///
	ti("12 month UIP deviation", size(medium)) legend(pos(6) label (1 "Canada") label (2 "Mexico") cols(1)) plotregion(style(none))
graph save Mex_Can_E12_month_UIP_Flows, replace


* Inflation
line Inflation_growth_percent time_q if(ISO_3_code == "CAN"), lc(blue) lwidth(thick)  ///
	|| (line Inflation_growth_percent time_q if(ISO_3_code == "MEX"), lc(red) lp(dash) lwidth(thick)) ,  ///
	xtitle("") xlab(, nogrid)  xlabel(#7, angle(45))  ///
	ytitle("y/y % change") ylab(-2(1)2, nogrid)  ///
	ti("Inflation", size(medium)) legend(pos(6) label (1 "Canada") label (2 "Mexico") cols(1)) plotregion(style(none)) 
graph save Mex_Can_Inflation_Growth, replace


* Policy Rate: we are not providing the raw data.
bysort IFS_code (time_q): gen policyRateChange = (i_policy_final - i_policy_final[1])

line policyRateChange time_q if(ISO_3_code == "CAN") , lc(blue) lwidth(thick)  ///
	|| (line policyRateChange time_q if(ISO_3_code == "MEX"), lc(red) lp(dash) lwidth(thick)),   /// 
	xtitle("")  xlab(, nogrid)  xlabel(#7, angle(45))  ///
	ytitle("p.p") ylab(-1(1)4, nogrid)  /// 
	ti("Policy Rate", size(medium)) legend(pos(6) label (1 "Canada") label (2 "Mexico") cols(1)) plotregion(style(none))
graph save Mex_Can_policyRateChange, replace


* Flows
bysort IFS_code (time_q): gen gr_bankycorp = bankcorp_inflow_AHKS_GDP_2023/bankcorp_inflow_AHKS_GDP_2023[1]

line gr_bankycorp time_q if(ISO_3_code == "CAN"), lc(blue) lwidth(thick)  ///
	|| (line gr_bankycorp time_q if(ISO_3_code == "MEX"), lc(red) lp(dash) lwidth(thick)) ,   ///
	xtitle("") xlab(, nogrid) xlabel(#7, angle(45))  ///
	ytitle("Ratio")  ylab(-2(2)16, nogrid)  ///
	ti("Capital Inflows to GDP", size(medium)) legend(pos(6) label (1 "Canada") label (2 "Mexico") cols(1)) plotregion(style(none))
graph save Mex_Can_Flows, replace

